import { NextResponse } from 'next/server';
import dbConnect from '@/lib/db';
import Leader from '@/models/Leader';

export async function POST(req: Request) {
  await dbConnect();
  try {
    const { updates } = await req.json();
    
    // Process updates in parallel
    await Promise.all(
      updates.map((update: { _id: string; order: number }) =>
        (Leader as any).findByIdAndUpdate(update._id, { order: update.order })
      )
    );

    return NextResponse.json({ success: true });
  } catch (error) {
    return NextResponse.json({ error: 'Failed to reorder' }, { status: 500 });
  }
}