import React from 'react';

export const metadata = {
  title: 'UKBCCI - UK-Bangladesh Catalysts of Commerce & Industry',
  description: 'Empowering UK-Bangladesh Trade',
  icons: {
    icon: '/logo.png',
    shortcut: '/logo.png',
    apple: '/logo.png',
  },
};

export default function RootLayout({
  children,
}: {
  children: React.ReactNode;
}) {
  return (
    <html lang="en" className="scroll-smooth">
      <head>
        <script src="https://cdn.tailwindcss.com"></script>
        <script
          dangerouslySetInnerHTML={{
            __html: `
              tailwind.config = {
                darkMode: "class",
                theme: {
                  extend: {
                    colors: {
                      primary: "#10B981", 
                      "primary-dark": "#059669", 
                      "secondary": "#1E293B", 
                      "background-light": "#F8FAFC", 
                      "background-dark": "#0F172A", 
                    },
                    fontFamily: {
                      sans: ['Plus Jakarta Sans', 'sans-serif'],
                      display: ['Plus Jakarta Sans', 'sans-serif'],
                    },
                    animation: {
                      'spin-slow': 'spin 10s linear infinite',
                    }
                  },
                },
              };
            `,
          }}
        />
        <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@300;400;500;600;700;800&display=swap" rel="stylesheet" />
        <style dangerouslySetInnerHTML={{
          __html: `
          .text-gradient {
            background-clip: text;
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-image: linear-gradient(to right, #10B981, #3B82F6);
          }
        `}} />
      </head>
      <body className="bg-background-light dark:bg-background-dark text-slate-800 dark:text-slate-200 font-sans antialiased">
        {children}
      </body>
    </html>
  );
}
