import React from 'react';
import Navbar from '@/components/Navbar';
import Footer from '@/components/Footer';
import dbConnect from '@/lib/db';
import Leader from '@/models/Leader';

export const revalidate = 60;

async function getLeaders() {
  try {
    await dbConnect();
    const leaders = await (Leader as any).find({ status: 'published' }).sort({ order: 1 }).lean();
    return JSON.parse(JSON.stringify(leaders));
  } catch (e) {
    return [];
  }
}

export default async function LeadershipPage() {
  const leaders = await getLeaders();

  return (
    <div className="min-h-screen flex flex-col">
      <Navbar />
      
      <main className="flex-grow bg-slate-900 text-white pb-24">
        <div className="py-20 bg-slate-800 text-center relative overflow-hidden">
             <div className="absolute inset-0 bg-gradient-to-b from-slate-900/50 to-slate-800 pointer-events-none"></div>
             <h1 className="text-4xl md:text-5xl font-bold font-display relative z-10 mb-4">Our <span className="text-primary">Leadership</span></h1>
             <p className="text-slate-400 max-w-2xl mx-auto relative z-10">Meet the visionaries guiding UKBCCI towards a prosperous future.</p>
        </div>

        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 mt-16">
          <div className="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-6">
            {leaders.map((leader: any, index: number) => (
              <div key={index} className="group relative">
                <div className="aspect-[3/4] rounded-xl overflow-hidden bg-slate-800 relative shadow-2xl">
                  <img 
                    src={leader.image || '/placeholder-leader.jpg'} 
                    alt={leader.name} 
                    loading="lazy"
                    className="w-full h-full object-cover group-hover:scale-105 transition duration-500 filter grayscale group-hover:grayscale-0"
                  />
                  <div className="absolute inset-0 bg-gradient-to-t from-slate-900 via-transparent to-transparent opacity-90"></div>
                  <div className="absolute bottom-0 left-0 w-full p-6">
                    <span className={`inline-block px-2 py-0.5 rounded ${leader.roleColor || 'bg-primary'} text-[0.6rem] font-bold text-white mb-2`}>
                      {leader.role}
                    </span>
                    <h3 className="text-lg font-bold leading-tight">{leader.name}</h3>
                  </div>
                </div>
              </div>
            ))}
          </div>
        </div>
      </main>

      <Footer />
    </div>
  );
}