import React from 'react';
import Navbar from '@/components/Navbar';
import Footer from '@/components/Footer';
import { Heart } from 'lucide-react';

export default function RemembrancePage() {
  return (
    <div className="min-h-screen flex flex-col bg-slate-50 dark:bg-slate-900">
      <Navbar />
      
      <main className="flex-grow">
        {/* Header Section */}
        <div className="bg-[#0F172A] text-white py-20 text-center relative overflow-hidden">
           <div className="absolute top-0 left-0 w-full h-full bg-[url('https://www.transparenttextures.com/patterns/cubes.png')] opacity-10"></div>
           <div className="relative z-10 max-w-4xl mx-auto px-4">
              <div className="w-16 h-16 mx-auto mb-6 text-primary">
                 <Heart size={64} strokeWidth={1.5} />
              </div>
              <h1 className="text-4xl md:text-5xl font-bold font-display mb-4">
                 In <span className="text-primary">Remembrance</span>
              </h1>
              <p className="text-slate-400 text-lg max-w-2xl mx-auto">
                 Honoring the legacy of our departed directors who shaped UKBCCI's journey
              </p>
           </div>
        </div>

        {/* Content Section */}
        <div className="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8 -mt-10 pb-20 relative z-20">
           <div className="grid md:grid-cols-2 gap-8">
              
              {/* Card 1 */}
              <div className="bg-slate-100 dark:bg-slate-800 rounded-lg p-10 border-t-8 border-slate-400 shadow-xl text-center flex flex-col items-center">
                 <div className="w-14 h-14 bg-white dark:bg-slate-700 rounded-full flex items-center justify-center text-primary mb-6 shadow-sm">
                    <Heart size={24} />
                 </div>
                 <h2 className="text-2xl font-bold text-slate-900 dark:text-white mb-2">Mr M A Rouf JP</h2>
                 <p className="text-primary font-bold mb-2 text-base">Senior Vice President & Director</p>
                 <p className="text-slate-500 text-sm mb-6 italic">September 2014 - March 2022</p>
                 
                 <div className="relative">
                    <div className="absolute top-0 left-0 -ml-4 -mt-2 text-4xl text-slate-300 font-display">"</div>
                    <p className="text-slate-600 dark:text-slate-300 italic text-sm leading-relaxed px-2">
                       Mr. Rouf was a renowned business person in the UK and in Bangladesh. He was not only a colleague of UKBCCI Directors and members but also a very close friend of few Directors. He was a lovely gentleman with a kind heart; he will be sorely missed by everyone in UKBCCI. May Allah grant him the highest-ranking in Jannahtul Firdaus InshaAllah.
                    </p>
                    <div className="absolute bottom-0 right-0 -mr-4 -mb-4 text-4xl text-slate-300 font-display leading-none">"</div>
                 </div>
              </div>

              {/* Card 2 */}
              <div className="bg-slate-100 dark:bg-slate-800 rounded-lg p-10 border-t-8 border-slate-400 shadow-xl text-center flex flex-col items-center">
                 <div className="w-14 h-14 bg-white dark:bg-slate-700 rounded-full flex items-center justify-center text-primary mb-6 shadow-sm">
                    <Heart size={24} />
                 </div>
                 <h2 className="text-2xl font-bold text-slate-900 dark:text-white mb-2">Mr M A Gani</h2>
                 <p className="text-primary font-bold mb-2 text-base">Vice President & Director</p>
                 <p className="text-slate-500 text-sm mb-6 italic">August 2015 - June 2022</p>
                 
                 <div className="relative">
                    <div className="absolute top-0 left-0 -ml-4 -mt-2 text-4xl text-slate-300 font-display">"</div>
                    <p className="text-slate-600 dark:text-slate-300 italic text-sm leading-relaxed px-2">
                       Mr. Gani was a renowned business person in the UK and in Bangladesh. Mr Gani was not only the UKBCCI's Director & Former Vice President but also very close to the UKBCCI family. He was a wonderful person with great integrity; he was always there to help whenever we needed him. UKBCCI has lost such a wonderful colleague. He will be sorely missed by everyone in the UKBCCI. May Allah grant him the highest-ranking in Jannahtul Firdaus InshaAllah.
                    </p>
                    <div className="absolute bottom-0 right-0 -mr-4 -mb-4 text-4xl text-slate-300 font-display leading-none">"</div>
                 </div>
              </div>

           </div>
           
           <div className="text-center mt-12 text-slate-400 text-sm italic">
              May their contributions and memories continue to inspire future generations
           </div>
        </div>
      </main>

      <Footer />
    </div>
  );
}
