import React from 'react';
import Navbar from '@/components/Navbar';
import Footer from '@/components/Footer';
import Newsletter from '@/components/Newsletter';
import { CheckCircle2, Star, ArrowRight } from 'lucide-react';
import Link from 'next/link';

export default function MembershipPage() {
  const plans = [
    {
      name: "Student",
      price: 50,
      description: "Perfect for students and young professionals starting their career journey",
      features: [
        "Access to networking events",
        "Educational resources and webinars",
        "Mentorship opportunities",
        "Career guidance and support",
        "Student community forums",
        "Discounted event tickets"
      ],
      highlight: false
    },
    {
      name: "Regular",
      price: 200,
      description: "Ideal for professionals and small to medium-sized businesses",
      features: [
        "All Student benefits included",
        "Priority event access and registration",
        "Business directory listing",
        "Monthly industry newsletters",
        "Expert business consultations",
        "Networking mixer invitations",
        "Access to trade reports",
        "Marketing opportunities"
      ],
      highlight: true
    },
    {
      name: "Corporate",
      price: 500,
      description: "Comprehensive package for established businesses seeking maximum value",
      features: [
        "All Regular benefits included",
        "Sponsorship opportunities at events",
        "Dedicated account manager",
        "Trade mission participation rights",
        "VIP access to exclusive events",
        "Speaking opportunities",
        "Premium directory placement",
        "Custom consultancy hours",
        "Annual recognition award"
      ],
      highlight: false
    }
  ];

  const steps = [
    { number: 1, title: "Choose Tier", desc: "Select your membership level" },
    { number: 2, title: "Fill Form", desc: "Complete the application" },
    { number: 3, title: "Payment", desc: "Process your membership fee" },
    { number: 4, title: "Get Started", desc: "Access member benefits" },
  ];

  return (
    <div className="min-h-screen flex flex-col bg-slate-50 dark:bg-slate-900">
      <Navbar />
      
      <main className="flex-grow">
        {/* Header Section */}
        <div className="bg-[#0F172A] text-white py-20 text-center relative overflow-hidden">
           <div className="absolute inset-0 z-0 opacity-20" style={{ backgroundImage: 'radial-gradient(#ffffff 1px, transparent 1px)', backgroundSize: '30px 30px' }}></div>
           
           <div className="relative z-10 max-w-4xl mx-auto px-4">
              <div className="inline-block border border-slate-600 bg-slate-800/50 backdrop-blur-sm px-4 py-1 rounded-full text-xs font-medium text-slate-300 mb-6">
                Become a Member
              </div>
              <h1 className="text-4xl md:text-6xl font-bold font-display mb-5">
                 Join <span className="text-primary">UKBCCI</span>
              </h1>
              <p className="text-slate-400 text-lg max-w-2xl mx-auto">
                 Choose the membership tier that best suits your needs and start building valuable connections today
              </p>
           </div>
        </div>

        {/* Pricing Section */}
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16 -mt-10 relative z-20">
           <div className="grid md:grid-cols-3 gap-6">
              {plans.map((plan, idx) => (
                 <div key={idx} className={`bg-white dark:bg-slate-800 rounded-2xl p-8 shadow-xl flex flex-col relative border ${plan.highlight ? 'border-primary ring-1 ring-primary' : 'border-slate-200 dark:border-slate-700'}`}>
                    {plan.highlight && (
                       <div className="absolute top-0 left-1/2 transform -translate-x-1/2 -translate-y-1/2 bg-primary text-white text-xs font-bold px-4 py-1 rounded-full shadow-lg">
                          Most Popular
                       </div>
                    )}
                    
                    <div className="text-center mb-8">
                       <div className={`w-12 h-12 mx-auto rounded-full flex items-center justify-center mb-5 ${plan.highlight ? 'bg-green-100 text-primary' : 'bg-slate-100 text-slate-500'}`}>
                          {plan.highlight ? <Star size={24} fill="currentColor" /> : <div className="border-2 border-current w-6 h-8 rounded-t-full rounded-b-md"></div>}
                       </div>
                       <h3 className="text-xl font-bold text-slate-900 dark:text-white mb-2">{plan.name}</h3>
                       <div className="flex items-baseline justify-center gap-1">
                          <span className="text-4xl font-bold text-primary">£{plan.price}</span>
                          <span className="text-slate-400 text-sm">/year</span>
                       </div>
                       <p className="text-slate-500 text-xs mt-4 px-2 leading-relaxed">{plan.description}</p>
                    </div>

                    <div className="border-t border-slate-100 dark:border-slate-700 my-6"></div>

                    <ul className="space-y-3 mb-8 flex-1">
                       {plan.features.map((feature, fIdx) => (
                          <li key={fIdx} className="flex items-start gap-3 text-sm text-slate-600 dark:text-slate-300">
                             <CheckCircle2 size={16} className="text-primary flex-shrink-0 mt-0.5" />
                             <span className="leading-tight">{feature}</span>
                          </li>
                       ))}
                    </ul>

                    <button className={`w-full py-3 rounded-lg font-bold text-sm transition flex items-center justify-center gap-2 ${plan.highlight ? 'bg-primary hover:bg-primary-dark text-white' : 'bg-slate-100 dark:bg-slate-700 text-slate-700 dark:text-white hover:bg-slate-200 dark:hover:bg-slate-600'}`}>
                       {plan.highlight ? `Apply for ${plan.name}` : `Apply for ${plan.name}`} <ArrowRight size={16} />
                    </button>
                    
                    <p className="text-[10px] text-slate-400 text-center mt-4">
                       By applying, you agree to our <a href="#" className="text-primary hover:underline">Privacy Policy</a>
                    </p>
                 </div>
              ))}
           </div>
        </div>

        {/* How to Apply */}
        <div className="bg-slate-50 dark:bg-slate-900 py-20">
           <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
              <h2 className="text-3xl font-bold text-slate-900 dark:text-white font-display mb-5">
                 How to <span className="text-primary">Apply</span>
              </h2>
              <div className="w-16 h-1 bg-slate-900 dark:bg-white mx-auto mb-5"></div>
              <p className="text-slate-500 text-base mb-12">Simple steps to become a UKBCCI member</p>

              <div className="grid grid-cols-2 md:grid-cols-4 gap-8">
                 {steps.map((step, idx) => (
                    <div key={idx} className="bg-white dark:bg-slate-800 p-8 rounded-xl shadow-sm hover:-translate-y-1 transition duration-300">
                       <div className="w-12 h-12 bg-primary text-white rounded-full flex items-center justify-center text-xl font-bold mx-auto mb-6 shadow-lg shadow-primary/30">
                          {step.number}
                       </div>
                       <h3 className="text-lg font-bold text-slate-900 dark:text-white mb-2">{step.title}</h3>
                       <p className="text-sm text-slate-500">{step.desc}</p>
                    </div>
                 ))}
              </div>
           </div>
        </div>

        <Newsletter />

      </main>
      <Footer />
    </div>
  );
}