import React from 'react';
import Navbar from '@/components/Navbar';
import Footer from '@/components/Footer';
import Newsletter from '@/components/Newsletter';
import {
  Briefcase,
  Globe,
  Users,
  TrendingUp,
  FileText,
  HeartHandshake,
  Lightbulb,
  Megaphone,
  ArrowRight,
  CheckCircle2,
  ShieldCheck,
  Sparkles
} from 'lucide-react';
import Link from 'next/link';

export default function ServicesPage() {
  const services = [
    {
      title: 'Business Advisory',
      icon: Briefcase,
      desc: 'Expert guidance on market entry strategies, regulatory compliance, and business development in both UK and Bangladesh markets.',
      points: ['Market research and analysis', 'Regulatory compliance support', 'Business strategy consultation', 'Risk assessment and mitigation']
    },
    {
      title: 'Trade Missions',
      icon: Globe,
      desc: 'Organized trade delegations to facilitate direct business connections and explore opportunities in target markets.',
      points: ['Curated B2B meetings', 'Factory and site visits', 'Government liaison support', 'Cultural orientation programs']
    },
    {
      title: 'Networking Events',
      icon: Users,
      desc: 'Regular networking opportunities to connect with industry leaders, potential partners, and key decision-makers.',
      points: ['Monthly business mixers', 'Industry-specific forums', 'Annual gala dinners', 'Executive roundtables']
    },
    {
      title: 'Market Intelligence',
      icon: TrendingUp,
      desc: 'Access to comprehensive market reports, industry insights, and economic data to inform your business decisions.',
      points: ['Quarterly market reports', 'Industry trend analysis', 'Sector-specific insights', 'Economic forecasts']
    },
    {
      title: 'Documentation Support',
      icon: FileText,
      desc: 'Assistance with business documentation, certifications, and legal requirements for cross-border operations.',
      points: ['Certificate of origin', 'Trade documentation', 'Attestation services', 'Legal compliance support']
    },
    {
      title: 'Business Matchmaking',
      icon: HeartHandshake,
      desc: 'Connecting businesses with suitable partners, suppliers, and distributors in UK and Bangladesh markets.',
      points: ['Partner identification', 'Due diligence support', 'Introduction services', 'Negotiation facilitation']
    },
    {
      title: 'Training & Workshops',
      icon: Lightbulb,
      desc: 'Professional development programs covering export management, cultural awareness, and business skills.',
      points: ['Export training programs', 'Cultural competency workshops', 'Leadership development', 'Digital transformation seminars']
    },
    {
      title: 'Advocacy & Representation',
      icon: Megaphone,
      desc: 'Representing member interests with government bodies and advocating for favorable business policies.',
      points: ['Government liaison', 'Policy advocacy', 'Industry representation', 'Stakeholder engagement']
    }
  ];

  const steps = [
    {
      title: 'Discover',
      text: 'We assess your goals and map the right UK-BD opportunities.',
    },
    {
      title: 'Connect',
      text: 'We introduce you to vetted partners, networks, and decision makers.',
    },
    {
      title: 'Execute',
      text: 'We support documentation, compliance, and commercial alignment.',
    },
    {
      title: 'Grow',
      text: 'We help scale relationships into long-term partnerships.',
    }
  ];

  return (
    <div className="min-h-screen flex flex-col bg-slate-50">
      <Navbar />
      <main className="flex-grow">
        {/* Hero */}
        <section className="relative bg-[#0F172A] text-white py-24 overflow-hidden">
          <div className="absolute inset-0 opacity-20" style={{ backgroundImage: 'radial-gradient(#ffffff 1px, transparent 1px)', backgroundSize: '30px 30px' }}></div>
          <div className="absolute inset-0 bg-gradient-to-r from-slate-900/60 to-slate-900/10"></div>
          <div className="relative z-10 max-w-5xl mx-auto px-4 text-center">
            <div className="inline-flex items-center gap-2 border border-white/30 bg-white/10 backdrop-blur-sm px-4 py-1 rounded-full text-xs font-semibold uppercase tracking-widest text-slate-200 mb-5">
              What We Offer
            </div>
            <h1 className="text-4xl md:text-6xl font-bold font-display mb-5">
              Our <span className="text-primary">Services</span>
            </h1>
            <p className="text-slate-300 text-lg max-w-2xl mx-auto">
              Comprehensive support for businesses navigating UK-Bangladesh trade and investment opportunities.
            </p>
          </div>
        </section>

        {/* Services Grid */}
        <section className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-20">
          <div className="grid md:grid-cols-2 gap-8">
            {services.map((service) => (
              <div key={service.title} className="bg-white rounded-2xl p-8 shadow-[0_18px_36px_-30px_rgba(15,23,42,0.35)] border border-slate-200 hover:shadow-[0_24px_44px_-30px_rgba(15,23,42,0.45)] transition">
                <div className="w-14 h-14 bg-emerald-100 rounded-2xl flex items-center justify-center text-primary mb-6">
                  <service.icon size={28} />
                </div>
                <h3 className="text-xl font-bold text-slate-900 mb-3">{service.title}</h3>
                <p className="text-slate-600 text-sm leading-relaxed mb-6">{service.desc}</p>
                <div className="space-y-2">
                  {service.points.map((point) => (
                    <div key={point} className="flex items-center gap-2 text-xs text-slate-600">
                      <CheckCircle2 size={14} className="text-primary flex-shrink-0" /> {point}
                    </div>
                  ))}
                </div>
              </div>
            ))}
          </div>
        </section>

        {/* Engagement Model */}
        <section className="py-24 bg-[linear-gradient(180deg,#ffffff_0%,#f3f7ff_100%)] border-t border-slate-200">
          <div className="max-w-6xl mx-auto px-4">
            <div className="flex items-center gap-2 mb-6">
              <div className="w-10 h-0.5 bg-primary"></div>
              <span className="text-sm font-bold uppercase tracking-widest text-primary">Engagement Model</span>
              <div className="w-2 h-2 rounded-full bg-[#BE123C]"></div>
            </div>
            <h2 className="text-3xl md:text-4xl font-bold text-slate-900 font-display mb-10">How We Work With Members</h2>
            <div className="grid md:grid-cols-4 gap-6">
              {steps.map((step, index) => (
                <div key={step.title} className="bg-white rounded-2xl p-6 border border-slate-200 shadow-[0_16px_32px_-28px_rgba(15,23,42,0.35)]">
                  <div className="w-9 h-9 rounded-full bg-primary text-white text-xs font-bold flex items-center justify-center mb-4">{index + 1}</div>
                  <h3 className="text-slate-900 font-bold mb-2">{step.title}</h3>
                  <p className="text-sm text-slate-600">{step.text}</p>
                </div>
              ))}
            </div>
          </div>
        </section>

        {/* Why UKBCCI */}
        <section className="py-24 bg-slate-950">
          <div className="max-w-6xl mx-auto px-4 text-center">
            <div className="inline-flex items-center gap-2 border border-white/20 bg-white/10 px-4 py-1.5 rounded-full text-xs font-semibold uppercase tracking-widest text-slate-200 mb-6">
              <Sparkles size={12} /> Trusted Advantage
            </div>
            <h2 className="text-3xl md:text-4xl font-bold text-white font-display mb-6">Why Businesses Choose UKBCCI</h2>
            <p className="text-slate-300 max-w-2xl mx-auto mb-12">
              We combine local market knowledge with trusted cross-border access to help members move faster and with confidence.
            </p>
            <div className="grid md:grid-cols-3 gap-6 text-left">
              {[
                { title: 'Verified Network', text: 'Direct connections with reliable partners and decision makers.', icon: Users },
                { title: 'Regulatory Guidance', text: 'Support to stay compliant and reduce friction in trade.', icon: ShieldCheck },
                { title: 'Commercial Results', text: 'Practical engagement focused on outcomes, not just meetings.', icon: Briefcase }
              ].map((item) => (
                <div key={item.title} className="bg-slate-900/70 border border-slate-800 rounded-2xl p-6">
                  <div className="w-12 h-12 rounded-xl bg-white/10 text-primary flex items-center justify-center mb-4">
                    <item.icon size={22} />
                  </div>
                  <h3 className="text-white font-bold mb-2">{item.title}</h3>
                  <p className="text-sm text-slate-300">{item.text}</p>
                </div>
              ))}
            </div>
          </div>
        </section>

        {/* CTA */}
        <section className="bg-white py-20 border-t border-slate-100">
          <div className="max-w-4xl mx-auto px-4 text-center">
            <h2 className="text-3xl font-bold text-slate-900 font-display mb-5">Ready to Get Started?</h2>
            <p className="text-slate-500 mb-10 max-w-xl mx-auto text-base">
              Contact us to learn how our services can help your business thrive in UK-Bangladesh markets.
            </p>
            <div className="flex justify-center gap-5">
              <Link href="/contact" className="bg-primary hover:bg-primary-dark text-white px-8 py-3.5 rounded-full font-bold transition flex items-center gap-2 text-base">
                Contact Us <ArrowRight size={18} />
              </Link>
              <Link href="/membership" className="bg-white border border-slate-300 text-slate-700 px-8 py-3.5 rounded-full font-bold transition hover:bg-slate-50 text-base">
                View Membership
              </Link>
            </div>
          </div>
        </section>

        <Newsletter />
      </main>
      <Footer />
    </div>
  );
}
