import React from 'react';
import Link from 'next/link';
import { Facebook, Camera, MonitorPlay, AtSign, MapPin, Mail, Phone, Lock } from 'lucide-react';

const Footer: React.FC = () => {
  return (
    <footer className="relative overflow-hidden bg-[linear-gradient(180deg,#020617_0%,#08122d_100%)] text-slate-300 text-sm border-t border-slate-800">
      <div className="absolute inset-0 bg-[radial-gradient(circle_at_top_left,rgba(14,58,138,0.24),transparent_35%),radial-gradient(circle_at_bottom_right,rgba(190,18,60,0.2),transparent_40%)]"></div>
      <div className="absolute top-0 left-0 right-0 h-1 bg-gradient-to-r from-[#0E3A8A] via-[#16A34A] to-[#BE123C]"></div>
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-14 relative z-10">
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-10">
          {/* Brand Column */}
          <div>
            <div className="bg-white rounded-lg p-2.5 w-fit mb-5 shadow-lg">
              <img src="/logo.png" alt="UKBCCI Logo" className="h-11 w-auto" />
            </div>
            <p className="mb-5 leading-relaxed text-slate-300">
              Empowering UK-Bangladesh businesses for tomorrow. At the root of tomorrow's new enterprise.
            </p>
            <div className="flex gap-4">
              <a href="#" className="w-10 h-10 rounded-full bg-white/5 border border-white/10 flex items-center justify-center hover:bg-primary hover:text-white transition"><Facebook size={18} /></a>
              <a href="#" className="w-10 h-10 rounded-full bg-white/5 border border-white/10 flex items-center justify-center hover:bg-primary hover:text-white transition"><Camera size={18} /></a>
              <a href="#" className="w-10 h-10 rounded-full bg-white/5 border border-white/10 flex items-center justify-center hover:bg-primary hover:text-white transition"><MonitorPlay size={18} /></a>
              <a href="#" className="w-10 h-10 rounded-full bg-white/5 border border-white/10 flex items-center justify-center hover:bg-primary hover:text-white transition"><AtSign size={18} /></a>
            </div>
          </div>

          {/* Quick Links */}
          <div>
            <h4 className="text-white font-bold mb-5 text-base">Quick Links</h4>
            <ul className="space-y-2.5">
              <li><Link href="/about" className="hover:text-primary transition text-slate-300">About Us</Link></li>
              <li><a href="/#leadership" className="hover:text-primary transition text-slate-300">Leadership</a></li>
              <li><Link href="/membership" className="hover:text-primary transition text-slate-300">Membership</Link></li>
              <li><a href="/#events" className="hover:text-primary transition text-slate-300">Events</a></li>
              <li><a href="/gallery" className="hover:text-primary transition text-slate-300">Gallery</a></li>
            </ul>
          </div>

          {/* Services */}
          <div>
            <h4 className="text-white font-bold mb-5 text-base">Our Services</h4>
            <ul className="space-y-2.5">
              <li><Link href="/services" className="hover:text-primary transition text-slate-300">Business Advisory</Link></li>
              <li><Link href="/services" className="hover:text-primary transition text-slate-300">Trade Missions</Link></li>
              <li><Link href="/services" className="hover:text-primary transition text-slate-300">Networking Events</Link></li>
              <li><Link href="/services" className="hover:text-primary transition text-slate-300">Expert Consultation</Link></li>
              <li><Link href="/services" className="hover:text-primary transition text-slate-300">Market Research</Link></li>
            </ul>
          </div>

          {/* Contact */}
          <div id="contact">
            <h4 className="text-white font-bold mb-5 text-base"><Link href="/contact">Contact Us</Link></h4>
            <ul className="space-y-3">
              <li className="flex items-start gap-3">
                <MapPin size={20} className="text-primary mt-0.5" />
                <span className="text-slate-300">London, United Kingdom</span>
              </li>
              <li className="flex items-center gap-3">
                <Mail size={20} className="text-primary" />
                <span className="text-slate-300">info@ukbcci.org.uk</span>
              </li>
              <li className="flex items-center gap-3">
                <Phone size={20} className="text-primary" />
                <span className="text-slate-300">07734 394192</span>
              </li>
            </ul>
          </div>
        </div>

        <div className="border-t border-white/10 mt-10 pt-5 flex flex-col md:flex-row justify-between items-center text-sm">
          <p className="text-slate-400">&copy; 2026 UK Bangladesh Catalysts of Commerce & Industry. All rights reserved.</p>
          <div className="flex gap-5 mt-4 md:mt-0 items-center">
            <a href="#" className="hover:text-white transition text-slate-400">Privacy Policy</a>
            <a href="#" className="hover:text-white transition text-slate-400">Terms of Service</a>
            {/* Use Link component here to fix connection refused errors in preview */}
            <Link href="/admin/login" className="flex items-center gap-2 hover:text-primary transition text-slate-400">
              <Lock size={14} /> Admin
            </Link>
          </div>
        </div>
      </div>
    </footer>
  );
};

export default Footer;
