'use client';
import React from 'react';
import { Send } from 'lucide-react';

export default function Newsletter() {
  return (
    <div className="bg-[#0F172A] border-t border-slate-800 py-16">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h2 className="text-xl font-bold text-white mb-2">Stay Connected with <span className="text-primary">UKBCCI</span></h2>
        <p className="text-slate-400 text-sm mb-6">Subscribe to our newsletter for the latest news, events, and business opportunities</p>
        
        <form className="max-w-md mx-auto flex gap-2" onSubmit={(e) => e.preventDefault()}>
           <input 
             type="email" 
             placeholder="Enter your email" 
             className="flex-1 bg-slate-800 border border-slate-700 text-white rounded-full px-5 py-2.5 focus:ring-2 focus:ring-primary focus:border-transparent outline-none text-sm placeholder-slate-500"
           />
           <button type="submit" className="bg-primary hover:bg-primary-dark text-white px-5 py-2.5 rounded-full font-bold transition flex items-center gap-2 text-sm">
             Subscribe <Send size={14} />
           </button>
        </form>
      </div>
    </div>
  );
}