import mongoose from 'mongoose';

const LeaderSchema = new mongoose.Schema({
  name: { type: String, required: true },
  role: { type: String, required: true }, // e.g. "CHAIRMAN"
  roleColor: { type: String, default: 'bg-primary' }, // Tailwind class
  image: String,
  order: { type: Number, default: 0 },
  status: { type: String, default: 'published' }
}, { timestamps: true });

export default mongoose.models.Leader || mongoose.model('Leader', LeaderSchema);