import mongoose from 'mongoose';

const PostSchema = new mongoose.Schema({
  title: { type: String, required: true },
  slug: { type: String, unique: true, required: true },
  content: String, // Rich text description
  excerpt: String,
  featuredImage: String,
  gallery: [String], // Post Gallery (Multiple Images)
  status: {
    type: String,
    enum: ['published', 'draft', 'scheduled'],
    default: 'published'
  },
  publishedAt: Date,
  author: {
    name: String,
    email: String,
    avatar: String
  },
  categories: [String], // Array of category slugs or names
  tags: [String],
  seo: {
    metaTitle: String,
    metaDescription: String,
    canonicalUrl: String,
    ogImage: String,
  }
}, { timestamps: true });

export default mongoose.models.Post || mongoose.model('Post', PostSchema);